function [zern_val] = zernike_moments(ROI_im,max_order,flag)

% if flag==1 - zernike magnitude only
% if flag==2 - zernike magnitude + phase

F=ROI_im;

F1 = -1 + 2.*(F - min(F(:)))./(max(F(:)) - min(F(:)));

L = size(F,1)-1;

x = (-L:2:L)/L;
[X,Y] = meshgrid(x);
[theta,r] = cart2pol(X,Y);

M= []; N = [];
for m = 0:max_order
    M= [M m*ones(1,m+1)];
    N = [N -m:2:m];
end


is_in_circle = ( r <= 1 );

[ax ay]=find_logical(is_in_circle);
   

Z=zeros([length(ax) size(M,2)]) ;
FF=reshape(F1(is_in_circle),[length(ax) 1]);

for t=1:size(M,2)
    [Z(:,t)] = zernfun_full(M(t),N(t),r(is_in_circle),theta(is_in_circle));
    
       
end
 
%Case 2:Least squares method  with sin, cos based polynomials
% 

 a1= Z\FF;

 a1=a1';


if flag==1
    posM=(N>0);
    negM=(N<0);
    zroM=(N==0);
    
    FTP=a1(:,posM);
    FTN=a1(:,negM);
    
    FTZ=a1(:,zroM);
    
    FTM = sqrt(FTP.^2 + FTN.^2);
    
    a0=[FTM FTZ];
end

if flag==1
    zern_val=a0;
end
if flag==2
    zern_val=a1;
end
end

